#ifndef DEBUG_H
#define DEBUG_H
#include <stdarg.h>
#include "structs.h"

#define INSANE 0
#define CRAZY 1
#define DEBUG 2
#define ALERT 3
#define MESSAGE 4
#define NORMAL 5 //this is the normal level
#define FRAME 6
#define QUIET 7
#define WARNING 6
#define ERROR 7

INLINE void print_to_stdout(char* msg, va_list);
INLINE void printd(int level, char* msg, ...);
INLINE void print_idata(int level, char *text, intersect_data *i_data);
INLINE void print_object(int level, char *text, int m);
INLINE void print_color(int level, char* text, color* c);
INLINE void print_vector(int level, char* text, vector* v);
INLINE void print_buffer(void );

#endif /* DEBUG */
